/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import java.io.Serializable;

public class UUID
implements Serializable {
    private static final long serialVersionUID = -1353723448254261874L;
    private byte[] bits;

    public UUID(byte[] bits) throws IllegalArgumentException {
        if (bits.length != 16) {
            throw new IllegalArgumentException("Exactly 16 bytes must be specified");
        }
        this.bits = bits;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        UUID uuid = (UUID)obj;
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == uuid.bits[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            sb.append(this.hexDigits(new Byte(this.bits[i]).intValue(), 2));
            if (i != 3 && i != 5 && i != 7 && i != 9) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    private String hexDigits(int value, int digits) {
        int hi = 1 << digits * 4;
        return Integer.toHexString(hi | value & hi - 1).substring(1);
    }
}

